
	; zero page vars
	src=$f7
	dst=$f9
	cnt=$fb
	laddr=$fb

        .word $0801
        * = $0801

        .word b_end
        .word 2025
        .byte $9e
        .asc " 2062"
        .byte 0
b_end   .word 0

	; https://www.hvsc.c64.org/download/C64Music/DOCUMENTS/SID_file_format.txt
        initaddr=tune+$0a
        playaddr=tune+$0c
	sidname=tune+$16
	sidauthor=tune+$36
	sidreleased=tune+$56

	headerlen=$7c
        pLoadAddr=tune+headerlen	; first two bytes of sid data
	dataaddr=tune+headerlen+2

main	
	; clear sid registers
	ldx #$17
	lda #$00
sidcl	sta $d400,x
	dex
	bpl sidcl

	; move sid data from data address to load address
	; src=data address
	lda #<dataaddr
	sta src
	lda #>dataaddr
	sta src+1

	; dst=(pLoadAddr)
	lda #<pLoadAddr
	sta laddr
	lda #>pLoadAddr
	sta laddr+1
	ldy #0
	lda (laddr),y
	sta dst
	iny
	lda (laddr),y
	sta dst+1

	lda songlen
	sta cnt
	lda songlen+1
	sta cnt+1

	jsr memCopy

	; load
	lda initaddr
	sta initptr+1
	lda initaddr+1
	sta initptr
	
	lda playaddr
	sta playptr+1
	lda playaddr+1
	sta playptr

	lda tune+$0e
	sta numSongs+1
	lda tune+$0f
	sta numSongs
	lda tune+$10
	sta startSong+1
	sta currentSong+1
	ldx tune+$11
	dex
	stx startSong

	jsr memDisableBASIC

	jsr clearScreen
	jsr clearColourRAM

	; border/bg colours
	lda #14
	sta $d020
	lda #15
	sta $d021
	; chr set 2
	lda #23
	sta $d018

	lda startSong
	jsr changeSong

	; install isr
	sei

        ; pointer to isr
        lda #<irq
        ldx #>irq
        sta $0314
        stx $0315

        ; raster interrupt at line $7e
        ldy #$7e
        sty $d012

        ; clear pending interrupts
        lda $dc0d
        lda $dd0d
	; clear vic interrupt flag
	lda #$ff
	sta $d019
        ;asl $d019

	lda #$7f
	sta $dc0d
	and $d011
	sta $d011
	sta $dc0d
	sta $dd0d
	; enable raster interrupts
	lda #$01
	sta $d01a

	cli

	; display sid info and timer
	; zp src = source ram
	; zp dst = destination ram
	; zp cnt = count
	; name
	ldx #<sidname
	stx src
	ldx #>sidname
	stx src+1
	ldx #$00
	stx dst
	ldx #$04
	stx dst+1
	ldx #$20
	stx cnt
	ldx #$0
	stx cnt+1
	jsr charCopy
	; author
	ldx #<sidauthor
	stx src
	ldx #>sidauthor
	stx src+1
	ldx tune+$10
	ldx #$28
	stx dst
	ldx #$04
	stx dst+1
	ldx #$20
	stx cnt
	ldx #$0
	stx cnt+1
	jsr charCopy
	; released
	lda #<sidreleased
	sta src
	lda #>sidreleased
	sta src+1
	ldx tune+$10
	ldx #$50
	stx dst
	ldx #$04
	stx dst+1
	ldx #$20
	stx cnt
	ldx #$0
	stx cnt+1
	jsr charCopy

	lda #'/'
	sta $0479
	lda numSongs
	clc
	adc #$30
	sta $047a
	lda #$3a
	sta $04a2

loopMain
	lda $d012
	bpl loopMain
	jsr checkKeyb
	jmp loopMain


; A = new tune number
changeSong
	sta currentSong
	jsr jinit
	lda currentSong
	clc
	adc #$31
	sta $0478
	ldx #0
	stx minutes
	stx seconds
	stx jiffies
	rts


minutes	.byte 0
seconds	.byte 0
jiffies	.byte 0

incTimer
	inc jiffies
	lda jiffies
	cmp #50
	bne tm_end2
	lda #0
	sta jiffies
	sed
	lda seconds
	clc
	adc #1
	sta seconds
	cmp #$60
	bne tm_end
	lda #0
	sta seconds

	lda minutes
	clc
	adc #1
	sta minutes
tm_end  cld
	lda minutes
	and #$f0
	lsr
	lsr
	lsr
	lsr
	clc
	adc #$30
	sta $04a0
	lda minutes
	and #$0f
	clc
	adc #$30
	sta $04a1
	lda seconds
	and #$f0
	lsr
	lsr
	lsr
	lsr
	clc
	adc #$30
	sta $04a3
	lda seconds
	and #$0f
	clc
	adc #$30
	sta $04a4
tm_end2	rts


irq	
	; border highlight
	lda #$7
	sta $d020

	jsr jplay

	; border normal
	lda #14
	sta $d020

        ; clear pending interrupts
        lda $dc0d
        lda $dd0d
	; clear vic interrupt flag
	lda #$ff
	sta $d019

	jsr incTimer

        ;jmp $ea31       ; normal interrupt routine
        ;jmp $ea81      ; normal interrupt routine no kbdscan
	pla
	tay
	pla
	tax
	pla
	rti


jinit		jmp (initptr)
jplay		jmp (playptr)


initptr		.word $0
playptr		.word $0
numSongs	.word $0
startSong	.word $0
currentSong	.word $0


memDisableBASIC
	lda #$36
	sta $01
	rts

memDisableKernal
	lda #$35
	sta $01
	rts

memEnableROM
	lda #$31
	sta $01
	rts


key	.byte $ff

keyrow
	.byte $df	;-
	.byte $df	;+
numkeys = * - keyrow

keycol
	.byte $08	;-
	.byte $01	;+

checkKeyb
		ldx key
		bmi kb_nopress
		lda keyrow,x
		sta $dc00
		lda $dc01
		and keycol,x
		beq kb_exit
kb_nopress	lda #numkeys-1
		tax
kb_keyloop	lda keyrow,x
		sta $dc00
		lda $dc01
		and keycol,x
		beq kb_found
		dex
		bpl kb_keyloop
		stx key
kb_exit		rts
kb_found	stx key
		txa
		cmp #0
		beq kb_decsong
		cmp #1
		beq kb_incsong
		rts
kb_decsong	ldx currentSong
		dex
		bmi kb_exit2
		txa
		jsr changeSong
kb_exit2	rts
kb_incsong	lda currentSong
		tax
		inx
		cpx numSongs
		beq kb_exit3
		txa
		jsr changeSong
kb_exit3	rts


; zp dst = destination ram
; zp cnt = count
; a = fill value
memSet
		ldy #0
fm_loop		sta (dst),y         ; write byte
		inc dst             ; advance low byte dest
		bne fm_no_inc_dst_hi
		inc dst+1
fm_no_inc_dst_hi
		dec cnt           ; low byte of length
		bne fm_loop
		dec cnt+1         ; high byte of length
		bpl fm_loop
		rts


; zp src = source ram
; zp dst = destination ram
; zp cnt = count
memCopy
		ldy #0              ; Y = 0 for 16-bit indirect indexed mode
mc_loop
		lda (src),y         ; read byte
		sta (dst),y         ; write byte
		inc src             ; advance low byte source
		bne mc_no_inc_src_hi
		inc src+1
mc_no_inc_src_hi
		inc dst             ; advance low byte dest
		bne mc_no_inc_dst_hi
		inc dst+1
mc_no_inc_dst_hi
		dec cnt           ; low byte of length
		bne mc_loop
		dec cnt+1         ; high byte of length
		bpl mc_loop
		rts


charCopy
		ldy #0              ; Y = 0 for 16-bit indirect indexed mode
cc_loop
		lda (src),y         ; read byte
		cmp #0
		bne cc_checklc
		lda #96
cc_checklc	cmp #97
		bmi cc_noconv
		sbc #96
cc_noconv	sta (dst),y         ; write byte
		inc src             ; advance low byte source
		bne cc_no_inc_src_hi
		inc src+1
cc_no_inc_src_hi
		inc dst             ; advance low byte dest
		bne cc_no_inc_dst_hi
		inc dst+1
cc_no_inc_dst_hi
		dec cnt           ; low byte of length
		bne cc_loop
		dec cnt+1         ; high byte of length
		bpl cc_loop
		rts


clearColourRAM	cram=$d800
		lda #<cram
		sta dst
		lda #>cram
		sta dst+1
		lda #$e8
		sta cnt
		lda #$03
		sta cnt+1
		lda #$00
		jsr memSet
		rts

clearScreen	screen=$0400
		lda #<screen
		sta dst
		lda #>screen
		sta dst+1
		; 40x25
		lda #$e8
		sta cnt
		lda #$03
		sta cnt+1
		lda #$20
		jsr memSet
		rts


#ifdef DEBUG
.include "sid_player_debug.inc"
#else

songlen	.word $0
tune

#endif

