//
// cores.cpp
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#include "cores.h"

TapCores::TapCores(CMemorySystem *pMemorySystem, CTimer *pTimer, CLogger *pLogger, Tap *pTap, TapeCart *pTapeCart, Display *pDisplay)
:
	CMultiCoreSupport (pMemorySystem),
	m_pTimer (pTimer),
	m_pLogger (pLogger),
	m_pTap (pTap),
	m_pTapeCart (pTapeCart),
	m_pDisplay (pDisplay)
{
}

void TapCores::Run(unsigned core)
{
	switch (core) {
		case 1:
			while(1)
			{
				// datasette mode
				m_pTap->hwInterface();
				// tapecart modes
				m_pTapeCart->hwInterface();
			}
			break;
		case 2:
			while(1)
			{
				m_pDisplay->drawScreen();
			}
			break;
		case 3:
			break;
		default:
			break;
	}
}

