//
// file.cpp
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <strings.h>

#include "file.h"

File::File (void)
{
}

File::~File (void)
{
}

boolean File::Initialize (void)
{
	return TRUE;
}

void File::bsort(FILINFO *d, int num)
{
	for(int i=0; i<num-1; i++)
	{
		for(int j=0; j<(num-i-1); j++)
		{
			if(strcasecmp(d[j].fname, d[j+1].fname) > 0)
			{
				FILINFO tmp=d[j];
				d[j]=d[j+1];
				d[j+1]=tmp;
			}
		}
	}
}

boolean File::fileStat (const char *f)
{
	FILINFO FileInfo;

	if(f_stat(f, &FileInfo)==FR_OK) return TRUE;
	else return FALSE;
}

int File::mkDir (const char *dir)
{
	FRESULT r;
	r=f_mkdir(dir);
	if(r!=FR_OK) return 0;
	return 1;
}

int File::readDir (FILINFO *dirlist, unsigned max, const char *dir)
{
	DIR Directory;
	FILINFO FileInfo;
	FRESULT Result = f_findfirst (&Directory, &FileInfo, dir, "*");
	unsigned i;
	for (i = 0; i<max && Result == FR_OK && FileInfo.fname[0]; i++)
	{
		dirlist[i]=FileInfo;
		Result = f_findnext (&Directory, &FileInfo);
	}
	bsort(dirlist, i);
	return i;
}

int File::rm (const char *path)
{
	FRESULT r;
	r=f_unlink(path);
	if(r!=FR_OK) return 0;
	return 1;
}

int File::writeFile (const u8 *data, unsigned size, const char *filename)
{
	FIL fp;
	unsigned bw;

	if (f_open(&fp, filename, FA_CREATE_ALWAYS|FA_WRITE)!=FR_OK) return 0;
	if (f_write(&fp, data, size, &bw)!=FR_OK) return 0;
	f_close(&fp);

	return 1;
}

