//
// cores.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#ifndef _cores_h
#define _cores_h

#include <circle/logger.h>
#include <circle/multicore.h>
#include <circle/types.h>

#include "display.h"
#include "tap.h"
#include "tapecart.h"

class TapCores : public CMultiCoreSupport
{
public:
	TapCores(CMemorySystem *pMemorySystem, CTimer *pTimer, CLogger *pLogger, Tap *pTap, TapeCart *pTapeCart, Display *pDisplay);
	virtual ~TapCores (void) = default;

	void Run (unsigned core); 
private:
	CTimer *m_pTimer;
	CLogger *m_pLogger;
	Tap *m_pTap;
	TapeCart *m_pTapeCart;
	Display *m_pDisplay;
};

#endif

