//
// display.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#ifndef _display_h
#define _display_h

#include <circle/2dgraphics.h>
#include <circle/devicenameservice.h>
#include <circle/input/mouse.h>
#include <circle/input/touchscreen.h>
#include <circle/types.h>
#include <circle/usb/usbkeyboard.h>

#include "fs.h"
#include "lcd.h"
#include "status.h"
#include "tap.h"
#include "tapecart.h"

#define MAX_DIR_ENTRIES		2048

#define SCREEN_WIDTH 1280
#define SCREEN_HEIGHT 720
#define BORDER_WIDTH   64
#define BORDER_HEIGHT  64
#define BROWSER_HEIGHT 22

#define COLOR_BG COLOR2D(0, 0, 170)
#define COLOR_FG COLOR2D(0, 136, 255)
#define COLOR_SELECT COLOR2D(255, 255, 255)

#define COLOR64_BLACK  COLOR2D(  0,   0,   0)
#define COLOR64_WHITE  COLOR2D(255, 255, 255)
#define COLOR64_RED    COLOR2D(136,   0,   0)
#define COLOR64_CYAN   COLOR2D(170, 255, 255)
#define COLOR64_VIOLET COLOR2D(204,  68, 204)
#define COLOR64_GREEN  COLOR2D(  0, 204,  85)
#define COLOR64_BLUE   COLOR2D(  0,   0, 170)
#define COLOR64_YELLOW COLOR2D(238, 238, 199)
#define COLOR64_ORANGE COLOR2D(221, 136,  85)
#define COLOR64_BROWN  COLOR2D(102,  68,   0)
#define COLOR64_LRED   COLOR2D(255, 119, 119)
#define COLOR64_GREY1  COLOR2D( 51,  51,  51)
#define COLOR64_GREY2  COLOR2D(119, 119, 119)
#define COLOR64_LGREEN COLOR2D(170, 255, 102)
#define COLOR64_LBLUE  COLOR2D(  0, 136, 255)
#define COLOR64_GREY3  COLOR2D(187, 187, 187)

class Display
{
public:
	Display (CDeviceNameService *, File *, FS *, Tap *, TapeCart *, Status *, CTimer *, LCD *);
	~Display (void);

	boolean Initialize (void);

	void drawScreen (void);

private:
	static void keyHandler (const char *);
	void touchEventHandler (TTouchScreenEvent Event, unsigned nId, unsigned nPosX, unsigned nPosY);
	static void touchEventStub (TTouchScreenEvent Event, unsigned nId, unsigned nPosX, unsigned nPosY);
	void mouseEventHandler (TMouseEvent Event, unsigned nButtons, unsigned nPosX, unsigned nPosY, int nWheelMove);
	static void mouseEventStub (TMouseEvent Event, unsigned nButtons, unsigned nPosX, unsigned nPosY, int nWheelMove);
	void drawDir (void);
	void selectDirEntry (void);
	void updateDir (void);
	void checkButtons (void);
	void navBack (void);

	CDisplay		*pCDisplay;
	u64			lastPulses[SCREEN_HEIGHT];

	//CString currentDir;
	FILINFO *dirList;
	//int dirNum;
	//int cursor;
	int textHeight=16;
	int text_y;
	//boolean dirChanged=FALSE;
	//boolean fileChanged=FALSE;
	//boolean recordStopped=FALSE;
	//boolean doScreenshot=FALSE;
	//boolean updateLCD=TRUE;

	//const char *lastKey;
	boolean mShowCursor=FALSE;
	unsigned mPosX;
	unsigned mPosY;
	unsigned mButtons;
	unsigned tPosX;
	unsigned tPosY;

	CDeviceNameService	*m_pDeviceNameService;
	CUSBKeyboardDevice	* volatile m_pKeyb;
	CMouseDevice		* volatile m_pMouse;
	CTouchScreenDevice	* volatile m_pTouchScreen;
	C2DGraphics		m_fb;
	CTimer			*m_pTimer;

	File			*m_pFile;
	FS			*m_pFS;
	Tap			*m_pTap;
	TapeCart		*m_pTapeCart;
	Status			*m_pStatus;
	LCD			*m_pLCD;

	static Display		*s_pThis;
};

#endif

