//
// fs.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#ifndef _fs_h
#define _fs_h

#include <circle/actled.h>
#include <circle/usb/usbhcidevice.h>
#include <fatfs/ff.h>

#include "status.h"
#include "tap.h"
#include "tapecart.h"
#include "taputils.h"

class FS
{
public:
	FS (CInterruptSystem *pInterrupt,
		CTimer *pTimer,
		CActLED *pActLED,
		File *pFile,
		Status *pStatus,
		Tap *pTap,
		TapeCart *pTapeCart,
		TapUtils *pTapUtils
		);
	~FS (void);

	boolean Initialize (void);

	int readFileIdx (u8 *data, const unsigned max_size, const char *filename);
	void freeImage(u32 *img_data);
	u32 *readFileImage (u8 *data, const unsigned max_size, const char *filename,
			int *width, int *height, int *channels);
	int idxToArray (const char *src, idx_entry_t dest[]);
	CString idxToJson (idx_entry_t idxTable[], unsigned count);
	int mountFile (const char *file);
	int mountTapecart (const char *file);
	void buildIndex(void);

private:
	void listRec(const char *path, FIL *fp_out);
	void unmountFile (void);

        CInterruptSystem        *m_pInterrupt;
        CTimer                  *m_pTimer;
	CActLED			*m_pActLED;
	File			*m_pFile;
	Status			*m_pStatus;
	Tap			*m_pTap;
	TapeCart		*m_pTapecart;
	TapUtils		*m_pTapUtils;
};

#endif

