//
// netutils.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#ifndef _netutils_h
#define _netutils_h

#include <circle/net/dnsclient.h>
#include <circle/net/netsubsystem.h>
#include <circle/net/ntpclient.h>

typedef enum {
  NET_NONE,
  NET_DNS_RESOLVE,
  NET_NTP_SYNC,
  NET_STATUS
} netFunction_t;

class NetUtils
{
public:
	NetUtils (CNetSubSystem *pNetSubSystem, CTimer *pTimer);
	~NetUtils (void);

	boolean Initialize (void);

	void runJob (void);
	CSpinLock jobLock;
	netFunction_t pendingJob=NET_NONE;

	void getNetStatus (void);
	boolean connected=FALSE;
	u32 ipAddr;
	u32 netMask;
	u32 gateway;
	u32 dnsServer;
	u32 broadcastAddr;
	const char *hostname;

	unsigned setNTPTime(void);
	void setTimeZone(int diff);
	void tcGetTime(u8 *timeData);

	char *DNSResolveName;
	u32 DNSResolveResult;
	u32 DNSResolve(const char *name);

	//CSpinLock ntpLock;
	//boolean doNTPUpdate=FALSE;
	unsigned lastNTPSync=0;

private:
	CDNSClient	*dnsClient;
	CNTPClient	*ntpClient;

	CNetSubSystem	*m_pNet;
	CTimer		*m_pTimer;
};

#endif

