//
// status.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#ifndef _status_h
#define _status_h

#include <circle/spinlock.h>
#include <circle/string.h>
#include <circle/types.h>

#include "taputils.h"

#define IMG_MAX_SIZE 1*1024*1024
#define TAP_MAX_SIZE 10*1024*1024
#define TCRT_MAX_SIZE 10*1024*1024

#define IDX_MAX_SIZE 10*1024
#define IDX_MAX_ENTRIES 100

typedef struct {
    unsigned	pos;
    u64		time;
    char	title[255];
} idx_entry_t;

enum option_types {
	OPTION_BOOLEAN,
	OPTION_STRING,
	OPTION_CHOICE
};

enum options {
	TCRT_SENSEMODE,
	CONVERSION_TYPE,
	TAP_CONVERSION_FORMAT,
	LOG_ENABLED,
	NUM_OPTIONS
};

typedef struct {
	int option_type;
	const char *name;
	const char *label;
	const char *description;
	char *value;
} pitap_option_t;


class Status
{
public:
	Status (void);
	~Status (void);
	boolean Initialize(void);
	CString getOptionsJson(void);
	void setOptions(const char *opts);

	pitap_option_t options[NUM_OPTIONS];
	boolean optionConvertToTapecart=TRUE;
	boolean optionShiftregEnableSense=TRUE;
	boolean optionLogEnabled=FALSE;
	tapConversions optionTapConversionFormat=TURBOTAPE64_WITH_LOADER;

	boolean rebootRequest = FALSE;

	CString ipAddress;
	unsigned cpuTemp=0;
	unsigned clockRate=0;

	unsigned counterSeconds;
	boolean isPlaying;
	boolean isRecording;
	boolean isMotorOn;
	boolean fileChanged = FALSE;

	CString currentTap="";
	char currentTapShort[255]="";
	unsigned tap_size=0;
	unsigned tap_length=0;
	u8 *tap_buffer=new u8[TAP_MAX_SIZE];

	CString currentTapecart="";
	boolean tapecartDynamic=FALSE;
	char currentTapecartShort[255]="";
	unsigned tapecart_size=0;
	u8 *tapecart_buffer=new u8[TCRT_MAX_SIZE];

	unsigned img_size=0;
	u8 *img_buffer=new u8[IMG_MAX_SIZE];
	u32 *img_data=0;
	int img_width, img_height, img_channels;

	u8 *idx_buffer=new u8[IDX_MAX_SIZE];
	unsigned idxCount;
	idx_entry_t idxTable[IDX_MAX_ENTRIES];
	CString idxJson;

	CSpinLock tcrtLock;
	boolean tapecartFileChanged=FALSE;

	void appendLog(CString);
	CString log;
private:

};

#endif

