//
// taputils.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifndef _taputils_h
#define _taputils_h

#include <circle/types.h>

enum tapConversions
{
	KERNAL,
	TURBOTAPE64,
	TURBOTAPE64_WITH_LOADER,
	TCRTLOADER,
	TCRT
};

class TapUtils
{
public:
	TapUtils (void);
	virtual ~TapUtils (void);

	unsigned prg2Tap (tapConversions type, const u8 *prgBuf, unsigned prgLen,
			u8 *tapBuf, unsigned tapPos, const char *name, u8 *idxBuf);
	unsigned d642Tap (tapConversions type, const u8 *d64Buf, unsigned d64Len,
			u8 *tapBuf, unsigned tapPos, const char *name, u8 *idxBuf);
	unsigned p002Tap (tapConversions type, const u8 *p00Buf, unsigned p00Len,
			u8 *tapBuf, unsigned tapPos, const char *name, u8 *idxBuf);
	unsigned sid2Tap (tapConversions type, u8 *sidBuf, unsigned sidBufLen, unsigned sidLen,
			u8 *tapBuf, unsigned tapPos, const char *name, u8 *idxBuf);
	unsigned t642Tap (tapConversions type, const u8 *t64Buf, unsigned t64Len,
			u8 *tapBuf, unsigned tapPos, const char *name, u8 *idxBuf);

	unsigned data2Tapecart(u8 *dataBuf, unsigned dataLen,
			u8 *tapecartBuffer, unsigned tapecartBufSize, const char *name);
	unsigned prg2Tapecart(const u8 *prgBuf, unsigned prgLen,
			u8 *tapecartBuffer, unsigned tapecartBufSize, const char *name);
	unsigned tapecartLoader2Tap (const u8 *tapecartBuffer, unsigned tapecartSize,
			u8 *tapBuf, unsigned tapPos, u8 *idxBuf);
	void mountTapecartTapLoader(u8 *tapecartBuffer, const char *filename);

	unsigned tapecartBrowserInit(u8 *tapecartBuffer, const char *name);
	unsigned tapecartBrowserAddPrg(u8 *prgBuf, unsigned prgLen, u8 *tapecartBuffer, unsigned tapecartSize, const char *name);

	u8 fromPetscii(u8 c);
	u8 toPetscii(u8 c);
	u8 toUpper(u8 c);

	// tapecart loader by Ingo Korb
	// https://github.com/ikorb/tapecart
	u8 tcrtLoader[171] = {
		#include "c64/tcrt_loader.h"
	};
	u8 tcrtVector[4] = {
		0x02, 0x03, 0x51, 0x03
	};
	u8 tcrtBasicStarter[10] = {
		0x20, 0x60, 0xa6, // jsr $a660
		0x20, 0x8e, 0xa6, // jsr $a68e
		0x4c, 0xae, 0xa7, // jmp $a7ae
		0x00              // $0800 must be zero
	};
	u8 tcrtTapStarter[182] = {
		#include "c64/tap_mount.h"
	};

	// tapecart browser by ALeX Kazik
	// https://github.com/alexkazik/tapecart-browser
	u8 tcrtBrowser[7517] = {
		#include "c64/browser.h"
	};

	//CString log;
private:
	void appendIdx (u8 *idxBuf, unsigned tapPos, const char *name);
	unsigned tapSpace (unsigned count, u8 *tapBuf);

	unsigned prg2Kernal (const u8 *prgBuf, unsigned prgLen, const u8 *headerDat, u8 *tapBuf, const char *name);
	unsigned kernalWriteByte(u8 *buf, u8 byte);
	unsigned kernalPulse(char pulseLen, u8 *buf, int count);

	size_t d64_offset(int track, int sector);
	const u8 *d64_get_sector(const u8 *img, int track, int sector);
	void d64_sanitize(unsigned char *s, int n);
	unsigned d64_extract_prg(const u8 *img, int start_track, int start_sector, const char *name,
				tapConversions type, u8 *tapBuf, unsigned tapPos, u8 *idxBuf);

	unsigned prg2TurboTape64 (const u8 *prgBuf, unsigned prgLen, u8 *tapBuf, const char *name);
	unsigned turboTape64WriteByte(u8 *buf, u8 byte);

	void asciiToUpper(const char *src, char *dest, size_t dest_len);
};

#endif

