#!/bin/bash

index=pitap-index.txt
pitap=pitap.lan

while [ ! x"${opts}" = x"break" ]	
do
	case "$1" in 
		-i)
			shift
			index="$1"
			shift
			;;
		-pi)
			shift
			pitap="$1"
			shift
			;;
		-g)
			shift
			getindex=1
			;;
		-u)
			upload=1
			shift
			file="$1"
			shift
			;;
		-d)
			shift
			dst="$1"
			shift
			;;
		-s)
			shift
			search="$1"
			shift
			;;
		-n)
			shift
			num="$1"
			shift
			;;
		*)
			opts="break"
			;;
	esac
done

generate_index() {
	curl ${pitap}/buildindex
	curl -s ${pitap}/download?file=/pitap/pitap-index.txt > ${index}
	echo index saved to ${index}
}

if [ ! -z "${getindex}" ]
then
	generate_index
	exit
fi

if [ ! -z "${upload}" ]
then
	curl -F "file=@${file}" ${pitap}/upload?dir=${dst}
	exit
fi

if [ ! -z "${search}" ]
then
	if [ ! -e "${index}" ]
	then
		generate_index
	fi

	echo searching for ${search}
	echo
	echo Matching images:
	echo
	grep -i "${search}" ${index} | sort | grep -n .

	if [ -z "${num}" ]
	then
		echo
		read -p "File: " num
	fi
	image=$(grep -i "${search}" ${index} | sort | head -n ${num} |tail -n 1)

	echo
	echo mounting ${image}
	curl --get --data-urlencode "file=${image}" ${pitap}/mount
	exit
fi


